import * as roomService from "./room.service.js";
export async function createRoom(req, res) {
    try {
        const room = await roomService.createRoom(req.body);
        res.status(201).json(room);
    }
    catch (err) {
        res.status(400).json({ message: err.message });
    }
}
export async function getRoomByCode(req, res) {
    try {
        const room = await roomService.getRoomByCode(req.params.code);
        res.json(room);
    }
    catch (err) {
        res.status(404).json({ message: err.message });
    }
}
